/******************************************************************************
	[Input.c]
		͂̎sȂ܂B

	Copyright (C) 2004 Ki

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
******************************************************************************/
#define DIRECTINPUT_VERSION		0x0500

#include <windows.h>
#include <dinput.h>
#include <string.h>

#include "InputInterface.h"
#include "WinMain.h"
#include "Printf.h"


#define INPUT_BUFFERSIZE		60*60*60*2						/* 60 frame * 60 sec * 60 min * 2 ~= 2 hours */
#define N_MAXJOYSTICK			5


static LPDIRECTINPUT			_pDI		= NULL;				// DirectInput C^[tF[X|C^
static LPDIRECTINPUTDEVICE		_pDIDKey	= NULL;				// DirectInput Keyboard device
static LPDIRECTINPUTDEVICE		_pDIDJoy[N_MAXJOYSTICK];		// DirectInput Joystick device


typedef struct
{
	Sint32	userButtonID;
	Sint32	inputButtonID;
} ButtonConnector;


typedef struct
{
	DIJOYSTATE					joyState;
	ButtonConnector				buttonConnector[INPUT_NUM_BUTTON];
	Uint16						nConnectedButtons;
	Uint16						buttonState;
	Sint32						xpos;
	Sint32						ypos;
	Sint32						xmin;
	Sint32						xmax;
	Sint32						ymin;
	Sint32						ymax;
} JOYSTICK;


static char						_DIKeys[256];					// L[{[h̃Xe[^Xz

static Sint32					_nJoySticks = 0;

static Uint16					_InputBuffer[INPUT_BUFFERSIZE];	// record pad #0 only
static Sint32					_InputBufferIndex;
static Sint32					_InputBufferIndexEnd;

static BOOL						_bRecord;
static BOOL						_bPlayback;
static BOOL						_bInit;

static JOYSTICK					_Joystick[N_MAXJOYSTICK];


static ButtonConnector			_KeyboardConnector[INPUT_NUM_BUTTON];
static Sint32					_nConnectedKeys;		/* keyboard */

/* used to restore key assignments for playback */
static ButtonConnector			_PlaybackButtonConnector[INPUT_NUM_BUTTON];
static Uint16					_nPlaybackConnectedButtons;


inline static BOOL is_up(JOYSTICK* pJoy)    { return pJoy->ypos <= (pJoy->ymax-pJoy->ymin)/4; }
inline static BOOL is_down(JOYSTICK* pJoy)  { return pJoy->ypos >= (pJoy->ymax-pJoy->ymin)*3/4; }
inline static BOOL is_left(JOYSTICK* pJoy)  { return pJoy->xpos <= (pJoy->xmax-pJoy->xmin)/4; }
inline static BOOL is_right(JOYSTICK* pJoy) { return pJoy->xpos >= (pJoy->xmax-pJoy->xmin)*3/4; }


/*-----------------------------------------------------------------------------
	[DIEnumDevicesCallback]
	JoyStickfoCX擾R[obN֐
	̂ƂlāA5܂Ŏ擾Ă
-----------------------------------------------------------------------------*/
static
BOOL
CALLBACK
DIEnumDevicesCallback(
	LPCDIDEVICEINSTANCE	lpddi,
	LPVOID				pvRef)
{
	HWND	hWnd;
	HRESULT hResult;

	hWnd = WINMAIN_GetHwnd();

	//WCXeBbNfoCX쐬
	hResult = _pDI->lpVtbl->CreateDevice(_pDI,&lpddi->guidInstance,&_pDIDJoy[_nJoySticks],NULL);
	if(hResult == DI_OK)
	{
		//f[^tH[}bgݒ肷
		hResult = _pDIDJoy[_nJoySticks]->lpVtbl->SetDataFormat(_pDIDJoy[_nJoySticks],&c_dfDIJoystick);
		if(hResult == DI_OK)
		{
			//xw肷
#ifdef DEBUGBUILD
			hResult=_pDIDJoy[_nJoySticks]->lpVtbl->SetCooperativeLevel(_pDIDJoy[_nJoySticks], hWnd, DISCL_EXCLUSIVE | DISCL_BACKGROUND);
#else
			hResult=_pDIDJoy[_nJoySticks]->lpVtbl->SetCooperativeLevel(_pDIDJoy[_nJoySticks], hWnd, DISCL_EXCLUSIVE | DISCL_FOREGROUND);
#endif
			if(hResult != DI_OK)
			{
				//s璆~ĎT
				return DIENUM_CONTINUE;
			}
		}
		else 
		{
			//s璆~ĎT
			return DIENUM_CONTINUE;
		}
	}
	else
	{
		//s璆~ĎT
		return DIENUM_CONTINUE;
	}

	_nJoySticks++;

	//Rg[5oꂽI
	if(_nJoySticks==N_MAXJOYSTICK)
	{
		//񋓂I
		return DIENUM_STOP;
	}
	else
	{
		//̃foCXT
		return DIENUM_CONTINUE;
	}
}


/*-----------------------------------------------------------------------------
	[Init]
		܂B
-----------------------------------------------------------------------------*/
BOOL
INPUT_Init(
	Sint32		inputType)
{
	HRESULT		hResult;
	HANDLE		hWnd;
	DIPROPRANGE	diDR;
	Uint32		i;

	if (_bInit)
		INPUT_Deinit();

	ZeroMemory(_Joystick, sizeof(_Joystick));
	_nConnectedKeys = 0;
	_InputBufferIndex = 0;

	hWnd = WINMAIN_GetHwnd();

	// DirectInputC^[tF[X擾
	if (DirectInputCreate(WINMAIN_GetHInstance(), DIRECTINPUT_VERSION, &_pDI, NULL) != DI_OK)
		return FALSE;

	//L[{[hfoCX擾
	if (_pDI->lpVtbl->CreateDevice(_pDI, &GUID_SysKeyboard, &_pDIDKey, NULL) != DI_OK)
		return FALSE;

	//f[^tH[}bgݒ肷
	if (_pDIDKey->lpVtbl->SetDataFormat(_pDIDKey, &c_dfDIKeyboard) != DI_OK)
		return FALSE;

	//xw肷
#ifdef DEBUGBUILD
	hResult=_pDIDKey->lpVtbl->SetCooperativeLevel(_pDIDKey, hWnd, DISCL_NONEXCLUSIVE | DISCL_BACKGROUND);
#else
	hResult=_pDIDKey->lpVtbl->SetCooperativeLevel(_pDIDKey, hWnd, DISCL_NONEXCLUSIVE | DISCL_FOREGROUND);
#endif

	if (hResult == DI_OK)
	{
		_pDIDKey->lpVtbl->Acquire(_pDIDKey);
	}

	//JoyStickfoCX񋓂
	_pDI->lpVtbl->EnumDevices(_pDI,DIDEVTYPE_JOYSTICK, DIEnumDevicesCallback, NULL, DIEDFL_ATTACHEDONLY);

	for (i = 0; i < _nJoySticks; i++)
	{
		//foCXX͔͈̓͂ǂݎ
		diDR.diph.dwSize       = sizeof(DIPROPRANGE);
		diDR.diph.dwHeaderSize = sizeof(DIPROPHEADER);
		diDR.diph.dwObj        = DIJOFS_X;
		diDR.diph.dwHow        = DIPH_BYOFFSET;
		_pDIDJoy[i]->lpVtbl->GetProperty(_pDIDJoy[i], DIPROP_RANGE, &diDR.diph);

		_Joystick[i].xmin = diDR.lMin;
		_Joystick[i].xmax = diDR.lMax;

		//foCXY͔͈̓͂ǂݎ
		diDR.diph.dwSize       = sizeof(DIPROPRANGE);
		diDR.diph.dwHeaderSize = sizeof(DIPROPHEADER);
		diDR.diph.dwObj        = DIJOFS_Y;
		diDR.diph.dwHow        = DIPH_BYOFFSET;
		_pDIDJoy[i]->lpVtbl->GetProperty(_pDIDJoy[i],DIPROP_RANGE,&diDR.diph);

		_Joystick[i].ymin = diDR.lMin;
		_Joystick[i].ymax = diDR.lMax;
	}

	if (_nJoySticks > 0)
		_bInit = TRUE;

	return _bInit;
}


/*-----------------------------------------------------------------------------
	[Deinit]
		I܂B
-----------------------------------------------------------------------------*/
void
INPUT_Deinit()
{
	Uint32		i;

	if (!_bInit)
		return;

	if (_pDIDKey != NULL)
	{
		_pDIDKey->lpVtbl->Unacquire(_pDIDKey);
		_pDIDKey->lpVtbl->Release(_pDIDKey);
		_pDIDKey = NULL;
	}

	for (i = 0; i < N_MAXJOYSTICK; ++i)
	{
		if (_pDIDJoy[i] != NULL)
		{
			_pDIDJoy[i]->lpVtbl->Unacquire(_pDIDJoy[i]);
			_pDIDJoy[i]->lpVtbl->Release(_pDIDJoy[i]);
			_pDIDJoy[i] = NULL;
		}
	}

	if (_pDI != NULL)
	{
		_pDI->lpVtbl->Release(_pDI);
		_pDI = NULL;
	}

	_nJoySticks = 0;
	_bInit = FALSE;
}


/*-----------------------------------------------------------------------------
	[ConnectButton]
		[U[`̃{^Ɠ̓{^ڑ܂B
-----------------------------------------------------------------------------*/
BOOL
INPUT_ConnectButton(
	Sint32		joyID,
	Sint32		userButtonID,
	Sint32		inputButtonID)
{
	if (!_bInit || joyID < 0 || joyID >= _nJoySticks)
		return FALSE;

	// ܂o^ł邩H 
	if (_Joystick[joyID].nConnectedButtons == INPUT_NUM_BUTTON)
		return FALSE;

	// o^ 
	_Joystick[joyID].buttonConnector[_Joystick[joyID].nConnectedButtons].userButtonID = userButtonID;
	_Joystick[joyID].buttonConnector[_Joystick[joyID].nConnectedButtons].inputButtonID = inputButtonID;

	++_Joystick[joyID].nConnectedButtons;

	return TRUE;
}


/*-----------------------------------------------------------------------------
	[ConnectKey]
		[U[`̃{^Ɠ̓L[ڑ܂B
-----------------------------------------------------------------------------*/
BOOL
INPUT_ConnectKey(
	Sint32		userButtonID,
	Sint32		inputKeyID)
{
	// ܂o^ł邩H 
	if (_nConnectedKeys == INPUT_NUM_BUTTON)
		return FALSE;

	// o^ 
	_KeyboardConnector[_nConnectedKeys].userButtonID = userButtonID;
	_KeyboardConnector[_nConnectedKeys].inputButtonID = inputKeyID;

	++_nConnectedKeys;

	return TRUE;
}



/*-----------------------------------------------------------------------------
	[UpdateState]
		͏󋵂XV܂B
-----------------------------------------------------------------------------*/
void
INPUT_UpdateState()
{
	int		i;

	if (_bPlayback)
	{
		_Joystick[0].buttonState = _InputBuffer[_InputBufferIndex++];
		if (_InputBufferIndex == _InputBufferIndexEnd)
		{
			PRINTF("INPUT: End of data;  now reading from normal input.");
			_bPlayback = FALSE;
		}
	}
	else
	{
		// WCXeBbÑXe[^Xǂ 
		if (_bInit)
		{
			HRESULT hResult;

			// L[{[h̏Ԃǂ
			hResult =_pDIDKey->lpVtbl->GetDeviceState(_pDIDKey, 256, &_DIKeys);

			// ǂݎɎs̏
			if (hResult != DI_OK)
			{
				// foCXւ̃ANZX擾
				hResult = _pDIDKey->lpVtbl->Acquire(_pDIDKey);
				if(hResult==DI_OK)
				{
					// L[{[h̏Ԃǂ
					hResult =_pDIDKey->lpVtbl->GetDeviceState(_pDIDKey, 256, &_DIKeys);
				}
			}

			// WCXeBbN݂鎞̓WCXeBbN̏Ԃǂ
			for (i = 0; i < _nJoySticks; ++i)
			{
				LPDIRECTINPUTDEVICE2	pDID;

				// foCXւ̃ANZX擾
				hResult = _pDIDJoy[i]->lpVtbl->Acquire(_pDIDJoy[i]);
				if (hResult != DI_OK)
				{
					hResult = _pDIDJoy[i]->lpVtbl->Acquire(_pDIDJoy[i]);
				}

				// |[OsȂ
				// IDirectInput ɂ Poll \bhȂ̂ IDirectInput2->Poll  
				_pDIDJoy[i]->lpVtbl->QueryInterface(_pDIDJoy[i], &IID_IDirectInputDevice2, (LPVOID*)&pDID);
				hResult=pDID->lpVtbl->Poll(pDID);
				if (hResult != DI_OK)
				{
					hResult = pDID->lpVtbl->Poll(pDID);
				}
				pDID->lpVtbl->Release(pDID);

				// WCXeBbN̏Ԃǂ
				_pDIDJoy[i]->lpVtbl->GetDeviceState(_pDIDJoy[i], sizeof(DIJOYSTATE), &_Joystick[i].joyState);

				// XY̏ԂXV
				_Joystick[i].xpos = _Joystick[i].joyState.lX;
				_Joystick[i].ypos = _Joystick[i].joyState.lY;

				// {^̏ԂXV (Ƃ肠 12 ̃{^ɑΉ)
				_Joystick[i].buttonState = 0;
				if (_Joystick[i].joyState.rgbButtons[0])	_Joystick[i].buttonState |= INPUT_JOYSTICK_BUTTON1;
				if (_Joystick[i].joyState.rgbButtons[1])	_Joystick[i].buttonState |= INPUT_JOYSTICK_BUTTON2;
				if (_Joystick[i].joyState.rgbButtons[2])	_Joystick[i].buttonState |= INPUT_JOYSTICK_BUTTON3;
				if (_Joystick[i].joyState.rgbButtons[3])	_Joystick[i].buttonState |= INPUT_JOYSTICK_BUTTON4;
				if (_Joystick[i].joyState.rgbButtons[4])	_Joystick[i].buttonState |= INPUT_JOYSTICK_BUTTON5;
				if (_Joystick[i].joyState.rgbButtons[5])	_Joystick[i].buttonState |= INPUT_JOYSTICK_BUTTON6;
				if (_Joystick[i].joyState.rgbButtons[6])	_Joystick[i].buttonState |= INPUT_JOYSTICK_BUTTON7;
				if (_Joystick[i].joyState.rgbButtons[7])	_Joystick[i].buttonState |= INPUT_JOYSTICK_BUTTON8;
				if (_Joystick[i].joyState.rgbButtons[8])	_Joystick[i].buttonState |= INPUT_JOYSTICK_BUTTON9;
				if (_Joystick[i].joyState.rgbButtons[9])	_Joystick[i].buttonState |= INPUT_JOYSTICK_BUTTON10;
				if (_Joystick[i].joyState.rgbButtons[10])	_Joystick[i].buttonState |= INPUT_JOYSTICK_BUTTON11;
				if (_Joystick[i].joyState.rgbButtons[11])	_Joystick[i].buttonState |= INPUT_JOYSTICK_BUTTON12;
				if (is_up(&_Joystick[i]))					_Joystick[i].buttonState |= INPUT_JOYSTICK_UP;
				if (is_down(&_Joystick[i]))					_Joystick[i].buttonState |= INPUT_JOYSTICK_DOWN;
				if (is_left(&_Joystick[i]))					_Joystick[i].buttonState |= INPUT_JOYSTICK_LEFT;
				if (is_right(&_Joystick[i]))				_Joystick[i].buttonState |= INPUT_JOYSTICK_RIGHT;

				// #0 ɂĂ̓L[{[h̓͂ɂĂXV 
				if (i == 0)
				{
					if (_DIKeys[DIK_D])			_Joystick[0].buttonState |= INPUT_JOYSTICK_BUTTON1;
					if (_DIKeys[DIK_F])			_Joystick[0].buttonState |= INPUT_JOYSTICK_BUTTON2;
					if (_DIKeys[DIK_TAB])		_Joystick[0].buttonState |= INPUT_JOYSTICK_BUTTON3;
					if (_DIKeys[DIK_RETURN])	_Joystick[0].buttonState |= INPUT_JOYSTICK_BUTTON4;
					if (_DIKeys[DIK_UP])		_Joystick[0].buttonState |= INPUT_JOYSTICK_UP;
					if (_DIKeys[DIK_DOWN])		_Joystick[0].buttonState |= INPUT_JOYSTICK_DOWN;
					if (_DIKeys[DIK_LEFT])		_Joystick[0].buttonState |= INPUT_JOYSTICK_LEFT;
					if (_DIKeys[DIK_RIGHT])		_Joystick[0].buttonState |= INPUT_JOYSTICK_RIGHT;
				}

				// WCXeBbN
				_pDIDJoy[i]->lpVtbl->Unacquire(_pDIDJoy[i]);
			}
		}

		if (_bRecord)
		{
			_InputBuffer[_InputBufferIndex++] = _Joystick[0].buttonState;

			if (_InputBufferIndex == INPUT_BUFFERSIZE)
			{
				PRINTF("INPUT: End of input buffer; recording stopped.");
				_bRecord = FALSE;
			}
		}
	}
}


/*-----------------------------------------------------------------------------
	[ClearState]
		͏󋵂NA܂D
-----------------------------------------------------------------------------*/
void
INPUT_ClearState()
{
	int			i;

	for (i = 0; i < _nJoySticks; ++i)
	{
		_Joystick[i].buttonState = 0;
	}
}


/*-----------------------------------------------------------------------------
	[IsPressed]
		w̃{^ꂽǂԂ܂D
-----------------------------------------------------------------------------*/
BOOL
INPUT_IsPressed(
	Sint32	joyID,
	Sint32	userButtonID)
{
	int					i;
	ButtonConnector*	pBC;
	int					nConnectedButtons;

	if (!_bInit || joyID < 0 || joyID >= _nJoySticks)
		return FALSE;

	if (_bPlayback)
	{
		pBC = _PlaybackButtonConnector;
		nConnectedButtons = _nPlaybackConnectedButtons;
	}
	else
	{
		pBC = _Joystick[joyID].buttonConnector;
		nConnectedButtons = _Joystick[joyID].nConnectedButtons;
	}

	for (i = 0; i < nConnectedButtons; i++)
	{
		if (pBC[i].userButtonID == userButtonID)
		{
			// PRINTF("buttonState = %d, inputButtonID = %d\n", _Joystick[joyID].buttonState, pBC[i].inputButtonID);
			return (_Joystick[joyID].buttonState & pBC[i].inputButtonID) != 0;
		}
	}

	return FALSE;
}


BOOL
INPUT_IsKeyPressed(
	Sint32		userKeyID)
{
	int			i;
	Sint32		keyID;

	if (!_bInit)
		return FALSE;

	for (i = 0; i < _nConnectedKeys; i++)
	{
		if (_KeyboardConnector[i].userButtonID == userKeyID)
		{
			keyID = _KeyboardConnector[i].inputButtonID;

			return (_DIKeys[keyID] != 0);
		}
	}

	return FALSE;
}


void
INPUT_Record(
	BOOL		bRecord)
{
	_bRecord = bRecord;

	if (_bRecord)
	{
		memset(_InputBuffer, 0, sizeof(_InputBuffer));
		_InputBufferIndex = 0;

		if (_bPlayback)
			_bPlayback = FALSE;
	}
}


void
INPUT_Playback(
	BOOL		bPlayback)
{
	_bPlayback = bPlayback;

	if (_bRecord)
		_bRecord = FALSE;

	_InputBufferIndex = 0;
}


BOOL
INPUT_WriteBuffer(
	FILE*		fp)
{
	if (fwrite(_Joystick[0].buttonConnector, sizeof(_Joystick[0].buttonConnector), 1, fp) != 1)	return FALSE;
	if (fwrite(&_Joystick[0].nConnectedButtons, sizeof(_Joystick[0].nConnectedButtons), 1, fp) != 1)	return FALSE;
//	if (fwrite(_KeyboardConnector, sizeof(_KeyboardConnector), 1, fp) != 1)		return FALSE;
//	if (fwrite(&_nConnectedKeys, sizeof(_nConnectedKeys), 1, fp) != 1)			return FALSE;
	if (fwrite(&_InputBufferIndex, sizeof(_InputBufferIndex), 1, fp) != 1)		return FALSE;

	return fwrite(_InputBuffer, sizeof(_InputBuffer), 1, fp) == 1;
}


BOOL
INPUT_ReadBuffer(
	FILE*		fp)
{
	if (fread(_PlaybackButtonConnector, sizeof(_PlaybackButtonConnector), 1, fp) != 1)		return FALSE;
	if (fread(&_nPlaybackConnectedButtons, sizeof(_nPlaybackConnectedButtons), 1, fp) != 1)	return FALSE;
//	if (fread(_PlaybackKeyboardConnector, sizeof(_PlaybackKeyboardConnector), 1, fp) != 1)	return FALSE;
//	if (fread(&_nPlaybackConnectedKeys, sizeof(_nPlaybackConnectedKeys), 1, fp) != 1)		return FALSE;
	if (fread(&_InputBufferIndexEnd, sizeof(_InputBufferIndexEnd), 1, fp) != 1)				return FALSE;

	return fread(_InputBuffer, sizeof(_InputBuffer), 1, fp) == 1;
}


Sint32
INPUT_GetNumJoystick()
{
	return _nJoySticks;
}


/*-----------------------------------------------------------------------------
	[IsTriggered]
	{^gKꂽǂԂ܂D
-----------------------------------------------------------------------------*/
BOOL
INPUT_IsTriggered(
	Sint32		userButtonID)
{
	/*  */
	return FALSE;
}


